# Vespucci 18.0 Highlights

2022-09-02

### Minimum supported Android version change

Android versions prior to 4.1 / API 16 are no longer supported. This means that Vespucci will no longer run on Android 4.0.1 to 4.0.4 that were published in 2011.

### Android 12 compatibility

Vespucci now targets Android 12 / API 31 as required by google. This has resulted in many smaller changes including the way the splash screen is displayed on devices with Android 5 and higher. 
   
### Layer state file name change

The mechanism that saves the current state (color, stroke width etc) of a layer displaying the contents of a file, for example GPX and GeoJSON layers, used a filename derived from the original filename and path. This could lead to filenames for the state file that exceeded Androids maximum filename length, particularly with files loaded from cloud services. The mechanism now use shorter names, however this is not backwards compatible and will require you to restyle any such layers.  

### Improvements to app startup

In the past we have used lazy loading for many configurations, that is we've read the configurations when they were 1st needed (if at all). However both the imagery and preset configuration have grown so much that this is no longer practical for these, besides not being obvious to the user what was going on, this had a tendency to cause _ANR_ (App Not Responding) messages on startup, that while harmless, were very annoying. We now force loading during display of the splash screen which avoids both the messages and provides feedback to the user. 

### Property editor changes

The property editor has been substantially reworked internally to support more flexible use. Currently user visible changes are limited to the ability to drill down to relation members and experimental support for displaying the property editor in a separate window when the device has split windows enabled. The later functionality needs to be explicitly enabled in the _Advanced preference_ in the _Experimental_ section.   

Further changes are expected in upcoming versions. 

### Auto-save support

Android apps can be paused and resumed at any time by the operating system and need to be able to save and restore their state so that they can seamlessly continue when a user returns to the app. In particular in Vespucci starting the property editor would always force such a state save, reducing the need for any kind of auto-save functionality as protection against crashes and other unforeseen mishaps. With the re-architecturing of the property editor in this release such forced saves are potentially less frequent and we have added an auto-save mechanism to compensate for that. 

See the _Advanced preferences_ documentation for more information.   

### Way geometry editing changes

The nodes of selected ways can now be moved without selecting the individual nodes, this make editing with a pen or a mouse substantially faster. As this may be problematic on small screen devices and when editing with fingers, this is by default turned off, but can be enabled directly in the 1st preferences screen.

If two ways overlap and share the same nodes for a segment and both are selected, dragging the geometry improvement handle will add a node to both ways. 

### Improved OSMOSE and Todo support

_Custom Bugs_ have been renamed to _Todos_ and support for directly creating them from selections is now supported. For example results of an object search could be added as individual todos to a specific todo list. Todo lists can be read and saved.

If an OSM object is selected that has an associated Todo or an OSMOSE bug, a new menu item will be displayed that offers two items:

- _Close and goto next_ - close the associated Todo and zoom to and select the object referenced in the next one in the list.
- _Close all tasks_ - close any Todos and OSMOSE bugs associated with the object.

OSMOSE 0.3 API is now fully supported

### Improved Maproulette support

Display of Maproulette tasks now supports moustache placeholders and other text replacements from the challenge configuration.

## Miscellaneous
 
- Add bridge casing to *_link highway objects
- Add use the floating button to exit rotation mode
- Add support renaming key values in the property editor when multiple objects are selected
- Add addr:parenstreet to address tags
- Add support a handle for changing the size of the panes in landscape mode on tablets

# Upgrading from previous versions

* As the saved state file has changed you should upload any pending changes before updating.

# Known problems

* The documentation is out of date.
* For other known problems with this build please see [our issue tracker](https://github.com/MarcusWolschon/osmeditor4android/issues)
